/*****************************************************************************
*  LPC11U6xx PWM program
*
*  1. Use SCT1 timer to generate a PWM output signal @ SCT1_OUT0
*  2. Every time SW1 goes high to low increase the duty cycle.
*  3. Every time SW2 goes high to low decrease the duty cycle.
*****************************************************************************/
#include "board.h"

extern void SCT1_Init(void);


void SCT1_Init(void)
{

	Chip_SCT_Init(LPC_SCT1);							   						                    //enable clock for SCT0/1

	Chip_SCT_Config(LPC_SCT1, SCT_CONFIG_AUTOLIMIT_L);							        //two 16-bit timers, clocked internally, auto limit


	Chip_SCT_SetControl(LPC_SCT1, SCT_CTRL_PRE_L((SystemCoreClock/1000000-1)));	// set prescaler, SCT clock = 1 MHz

	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_0,19);					   		        // match 0 @ 20/1MHz = 20 usec (50 KHz PWM freq)
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_0, 19);

	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_1,5);					   		        // match 1 used for duty cycle (in 20 steps)
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_1, 5);

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_0, ENABLE_STATE0);					    // event 0 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH0	|			  // related to match 0
                                                                              SCT_COMBMODE_MATCH	|			  // COMBMODE[13:12] = match condition only
                                                                              SCT_STATELD_1		|			    // STATELD[14] = STATEV is loaded into state
                                                                              SCT_STATEEV_0	        ));			  // STATEV[15] = 0

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_1, ENABLE_STATE0);					    // event 1 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_1, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH1	|			  // related to match 1
                                                                              SCT_COMBMODE_MATCH	|			  // COMBMODE[13:12] = match condition only
                                                                              SCT_STATELD_1		|			  // STATELD[14] = STATEV is loaded into state
                                                                              SCT_STATEEV_0		));			// STATEV[15] = 0


	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_0 , SCT_EVT_0);						      // event 0 will set SCTx_OUT0
	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_0, SCT_EVT_1);					      // event 1 will clear SCTx_OUT0


	Chip_SCT_ClearControl(LPC_SCT1, SCT_CTRL_HALT_L);							          // unhalt it by clearing bit 2 of the CTRL register
}




int main (void) 
{

	static uint8_t trg1 = 1;
	static uint8_t trg2 = 1;


	SystemCoreClockUpdate();
	Board_Init();


	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);				                // enable clock for IOCON


	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,16 , 0x00000081);				              // P2_16 is SCT1_OUT0

    SCT1_Init();                                   					              // Initialize SCT


    while (1)                                              			          // loop forever
    {
        if (!Chip_GPIO_GetPinState(LPC_GPIO, 0, 16) && trg1)    	        // SW1 high to low?
        {
            trg1 = 0;                                      			          // trigger SW1 low
            if (LPC_SCT1->MATCHREL[1].L < 19)
                LPC_SCT1->MATCHREL[1].L ++;                			          // increase PWM duty cycle
        }
        else if (Chip_GPIO_GetPinState(LPC_GPIO, 0, 16) && !trg1)	        // SW1 low to high?
        {
            trg1 = 1;                                      			          // trigger SW1 high
        }

        if (!Chip_GPIO_GetPinState(LPC_GPIO, 0, 1) && trg2)               // SW2 high to low?
        {
            trg2 = 0;                                      			          // trigger SW2 low
            if (LPC_SCT1->MATCHREL[1].L > 0)
                LPC_SCT1->MATCHREL[1].L --;                			          // decrease PWM duty cycle
        }
        else if (Chip_GPIO_GetPinState(LPC_GPIO, 0, 1) && !trg2)          // SW2 low to high?
        {
            trg2 = 1;                                      			          // trigger P0.1 high
        }
    }
}

